/*------------------------------------
	MCCellControllerProtocol.h  -  CellController

    The cell controller object is instantiated in IB and is attached to a view
    and typically a binder.  It knows how to replicate itself inside a destination
    view (using the class methods).

    The CellCtlPopulator class provides a convenient palettized object that can
    be used to call the populating class methods with all the options.  This class
    also provides some useful model (binder) methods which handle lists of models
    for the typical cases.

	RCS Information
	=============
	$Log: MCCellControllerProtocol.h,v $
	Revision 1.1  2001/11/18 22:36:01  alykhan
	Added CellController and CellControllerPopulator
	
	Revision 1.1  1998/05/07 15:30:45  cwhite
	*** empty log message ***

	Revision 1.3  1998/03/27 20:24:02  sbwoodsi
	added binder accessor

*/

#import <AppKit/AppKit.h>

#import "MCCellControllerPopulator.h"

@protocol MCCellControllerProtocol

+ (void)calculateMaximumCellsHigh:(int *)pNumHigh
                          andWide:(int *)pNumWide
                      forTemplate:aTemplate
                           inView:(NSView *)aView;

+ (NSArray *)populateView:(NSView *)aView
             withTemplate:aTemplate
              setDelegate:aDelegate
              resizeViews:(BOOL)resizable
               keepAspect:(BOOL)keepAspect
            rowMajorOrder:(BOOL)rowMajor
          overlapOnePixel:(BOOL)overlapPixel
               beginAtTop:(BOOL)startAtTop;

+ (NSArray *)populateView:(NSView *)aView
             withTemplate:aTemplate
                  numHigh:(int)numHigh
                  numWide:(int)numWide
              setDelegate:aDelegate
              resizeViews:(BOOL)resizable
               keepAspect:(BOOL)keepAspect
            rowMajorOrder:(BOOL)rowMajor
          overlapOnePixel:(BOOL)overlapPixel
               beginAtTop:(BOOL)startAtTop;

- (void)setModel:aModel;
- (void)setModelNoUpdate:aModel;
- model;
- binder;

- (void)setOtherObjects:anArray;
- (id)otherObjects;

- (void)updateInterfaceFromModel;
- (void)updateModelFromInterface;

- (void)setDelegate:(id)anObject;
- delegate;

- (NSRect)bounds;
- (NSRect)frame;
- (NSView *)view;
- (void)setFrameSize:(NSSize)_newSize;
- (void)placeViewAtX:(float)xVal Y:(float)yVal inSuperview:aView;

- replicate;

@end

